require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartWherigoKinzuaEagles = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartWherigoKinzuaEagles.MsgBoxCBFuncs = {}

zmediazookeeper = Wherigo.ZMedia(cartWherigoKinzuaEagles)
zmediazookeeper.Name="zookeeper"
zmediazookeeper.Description=""
zmediazookeeper.AltText=""
zmediazookeeper.Id="35686170-d8eb-4d64-b135-909b4722ef11"
zmediazookeeper.Resources = {
{ Type = "jpg", Filename = "zookeeper.jpg", Directives = {},},
}
zmediaeagle = Wherigo.ZMedia(cartWherigoKinzuaEagles)
zmediaeagle.Name="eagle"
zmediaeagle.Description=""
zmediaeagle.AltText=""
zmediaeagle.Id="d2b85ac0-d7ae-423b-8ea4-e103d5903d8f"
zmediaeagle.Resources = {
{ Type = "jpg", Filename = "baldeagleresized.jpg", Directives = {},},
}
-- Cartridge Info --
cartWherigoKinzuaEagles.Id="667452e2-901a-4170-bc35-a336491d2570"
cartWherigoKinzuaEagles.Name="Wherigo Kinzua Eagles"
cartWherigoKinzuaEagles.Description=[[This Wherigo cartridge is at the "Big Bend" area below the Kinzua Dam. Along the way you wil need to read the informational signs and correctly answer four questions before reaching the cache. Pay special attention to any information about the bald eagle! This cartridge and cache were placed for the "Caching With Eagles II event on 02/05/2011.]]
cartWherigoKinzuaEagles.Visible=true
cartWherigoKinzuaEagles.Activity="TourGuide"
cartWherigoKinzuaEagles.StartingLocationDescription=[[Big Bend Visitors Center. After comleting the cartridge and finding the cache, this is a great place to vsit.]]
cartWherigoKinzuaEagles.StartingLocation = ZonePoint(41.8409999847412,-79.0113333334525,0)
cartWherigoKinzuaEagles.Version="1.0"
cartWherigoKinzuaEagles.Company=""
cartWherigoKinzuaEagles.Author="MickEMT"
cartWherigoKinzuaEagles.BuilderVersion="2.0.5129.5086"
cartWherigoKinzuaEagles.CreateDate="1/26/2011 4:01:11 AM"
cartWherigoKinzuaEagles.PublishDate="2/5/2011 10:54:20 PM"
cartWherigoKinzuaEagles.UpdateDate="2/5/2011 10:53:09 PM"
cartWherigoKinzuaEagles.LastPlayedDate="1/1/0001 12:00:00 AM"
cartWherigoKinzuaEagles.TargetDevice="PocketPC"
cartWherigoKinzuaEagles.TargetDeviceVersion="0"
cartWherigoKinzuaEagles.StateId="1"
cartWherigoKinzuaEagles.CountryId="2"
cartWherigoKinzuaEagles.Complete=false
cartWherigoKinzuaEagles.UseLogging=true

-- Zones --
zoneZone1 = Wherigo.Zone(cartWherigoKinzuaEagles)
zoneZone1.Id="94ebf343-befe-4102-ab72-425dfb791c6a"
zoneZone1.Name="Zone 1 "
zoneZone1.Description=[[]]
zoneZone1.Visible=false
zoneZone1.DistanceRange = Distance(1500, "feet")
zoneZone1.ShowObjects="OnProximity"
zoneZone1.ProximityRange = Distance(20, "feet")
zoneZone1.AllowSetPositionTo=false
zoneZone1.Active=false
zoneZone1.Points = {
  ZonePoint(41.84165,-79.01328,0),
  ZonePoint(41.84165,-79.01322,0),
  ZonePoint(41.84161,-79.01322,0),
  ZonePoint(41.84161,-79.01328,0)
}
zoneZone1.OriginalPoint = ZonePoint(41.8416333516439,-79.0132500002781,0)
zoneZone1.DistanceRangeUOM = "Feet"
zoneZone1.ProximityRangeUOM = "Feet"
zoneZone1.OutOfRangeName = ""
zoneZone1.InRangeName = ""

zoneZone2 = Wherigo.Zone(cartWherigoKinzuaEagles)
zoneZone2.Id="fb8316bd-21dc-4051-814e-2a9013a59bdd"
zoneZone2.Name="Zone 2"
zoneZone2.Description=[[]]
zoneZone2.Visible=false
zoneZone2.DistanceRange = Distance(1500, "feet")
zoneZone2.ShowObjects="OnProximity"
zoneZone2.ProximityRange = Distance(20, "feet")
zoneZone2.AllowSetPositionTo=false
zoneZone2.Active=false
zoneZone2.Points = {
  ZonePoint(41.8416,-79.01378,0),
  ZonePoint(41.8416,-79.01372,0),
  ZonePoint(41.84156,-79.01372,0),
  ZonePoint(41.84156,-79.01378,0)
}
zoneZone2.OriginalPoint = ZonePoint(41.8415833155314,-79.0137499998013,0)
zoneZone2.DistanceRangeUOM = "Feet"
zoneZone2.ProximityRangeUOM = "Feet"
zoneZone2.OutOfRangeName = ""
zoneZone2.InRangeName = ""

zoneZone3 = Wherigo.Zone(cartWherigoKinzuaEagles)
zoneZone3.Id="ca905bb6-d6a0-48cd-9bd3-53cff85141fc"
zoneZone3.Name="Zone 3"
zoneZone3.Description=[[]]
zoneZone3.Visible=false
zoneZone3.DistanceRange = Distance(1500, "feet")
zoneZone3.ShowObjects="OnProximity"
zoneZone3.ProximityRange = Distance(20, "feet")
zoneZone3.AllowSetPositionTo=false
zoneZone3.Active=false
zoneZone3.Points = {
  ZonePoint(41.84194,-79.01526,0),
  ZonePoint(41.84194,-79.01521,0),
  ZonePoint(41.8419,-79.01521,0),
  ZonePoint(41.8419,-79.01526,0)
}
zoneZone3.OriginalPoint = ZonePoint(41.8419166564941,-79.0152333329121,0)
zoneZone3.DistanceRangeUOM = "Feet"
zoneZone3.ProximityRangeUOM = "Feet"
zoneZone3.OutOfRangeName = ""
zoneZone3.InRangeName = ""

zoneZone4 = Wherigo.Zone(cartWherigoKinzuaEagles)
zoneZone4.Id="8b48384b-1c61-48f7-80cc-036e94355468"
zoneZone4.Name="Zone 4 "
zoneZone4.Description=[[]]
zoneZone4.Visible=false
zoneZone4.DistanceRange = Distance(1500, "feet")
zoneZone4.ShowObjects="OnProximity"
zoneZone4.ProximityRange = Distance(25, "feet")
zoneZone4.AllowSetPositionTo=false
zoneZone4.Active=false
zoneZone4.Points = {
  ZonePoint(41.84219,-79.01627,0),
  ZonePoint(41.84219,-79.0162,0),
  ZonePoint(41.84214,-79.0162,0),
  ZonePoint(41.84214,-79.01627,0)
}
zoneZone4.OriginalPoint = ZonePoint(41.8421666463216,-79.0162333329519,0)
zoneZone4.DistanceRangeUOM = "Feet"
zoneZone4.ProximityRangeUOM = "Feet"
zoneZone4.OutOfRangeName = ""
zoneZone4.InRangeName = ""

zoneFinal = Wherigo.Zone(cartWherigoKinzuaEagles)
zoneFinal.Id="87ebeef9-47cd-44b7-b09b-2d3d420eed1c"
zoneFinal.Name="Final"
zoneFinal.Description=[[]]
zoneFinal.Visible=false
zoneFinal.DistanceRange = Distance(1500, "feet")
zoneFinal.ShowObjects="OnProximity"
zoneFinal.ProximityRange = Distance(20, "feet")
zoneFinal.AllowSetPositionTo=false
zoneFinal.Active=false
zoneFinal.Points = {
  ZonePoint(41.8421,-79.01691,0),
  ZonePoint(41.8421,-79.01686,0),
  ZonePoint(41.84206,-79.01686,0),
  ZonePoint(41.84206,-79.01691,0)
}
zoneFinal.OriginalPoint = ZonePoint(41.8420833587647,-79.0168833335241,0)
zoneFinal.DistanceRangeUOM = "Feet"
zoneFinal.ProximityRangeUOM = "Feet"
zoneFinal.OutOfRangeName = ""
zoneFinal.InRangeName = ""

-- Characters --
zcharacterTourguide = Wherigo.ZCharacter{Cartridge=cartWherigoKinzuaEagles, Container=zoneZone1}
zcharacterTourguide.Id="cb3a002a-c951-439f-9391-9b6e343a1563"
zcharacterTourguide.Name="Tourguide"
zcharacterTourguide.Description=[[]]
zcharacterTourguide.Visible=false
zcharacterTourguide.Media=zmediazookeeper
zcharacterTourguide.Gender="Male"
zcharacterTourguide.Type="NPC"
zcharacterTourguide.ObjectLocation = ZonePoint(41.8416408255746,-79.0132500013596,360)
zcharacterTourguide.Commands = {
  Givecodewordfromcache = Wherigo.ZCommand{Text="Give code word from cache", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Getsecondquestion = Wherigo.ZCommand{Text="Get second question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Getthirdquestion = Wherigo.ZCommand{Text="Get third question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Getfirstquestion = Wherigo.ZCommand{Text="Get first question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
  Getfourthquestion = Wherigo.ZCommand{Text="Get fourth question", CmdWith=false, Enabled=false, EmptyTargetListText="Nothing available"},
}
zcharacterTourguide.Commands.Givecodewordfromcache.Custom = true
zcharacterTourguide.Commands.Givecodewordfromcache.Id="9062909a-ba01-414b-a9ff-c1a2a17d6048"
zcharacterTourguide.Commands.Givecodewordfromcache.WorksWithAll = true
zcharacterTourguide.Commands.Getsecondquestion.Custom = true
zcharacterTourguide.Commands.Getsecondquestion.Id="6178ef6f-1b5e-44c7-ab30-b3753a36667e"
zcharacterTourguide.Commands.Getsecondquestion.WorksWithAll = true
zcharacterTourguide.Commands.Getthirdquestion.Custom = true
zcharacterTourguide.Commands.Getthirdquestion.Id="d2b5b49d-ea83-4cc1-b0db-0d695b6324f4"
zcharacterTourguide.Commands.Getthirdquestion.WorksWithAll = true
zcharacterTourguide.Commands.Getfirstquestion.Custom = true
zcharacterTourguide.Commands.Getfirstquestion.Id="89f6976b-cd7f-4098-937c-5a0de3959883"
zcharacterTourguide.Commands.Getfirstquestion.WorksWithAll = true
zcharacterTourguide.Commands.Getfourthquestion.Custom = true
zcharacterTourguide.Commands.Getfourthquestion.Id="3b4a71d9-7cb7-4bd3-b70c-050c43fc061e"
zcharacterTourguide.Commands.Getfourthquestion.WorksWithAll = true

zcharacterEagle = Wherigo.ZCharacter(cartWherigoKinzuaEagles)
zcharacterEagle.Id="1915a1e8-0461-49a5-a4ab-0458d91cc08b"
zcharacterEagle.Name="Eagle"
zcharacterEagle.Description=[[]]
zcharacterEagle.Visible=false
zcharacterEagle.Media=zmediaeagle
zcharacterEagle.Gender="It"
zcharacterEagle.Type="NPC"
zcharacterEagle.ObjectLocation = Wherigo.INVALID_ZONEPOINT

-- Items --

-- Tasks --

-- Cartridge Variables --
zone2variable = 0
zone1variable = 0
zone3variable = 0
zone4variable = ""
finalvariable = ""
cartWherigoKinzuaEagles.ZVariables = {zone2variable = 0, zone1variable = 0, zone3variable = 0, zone4variable = "", finalvariable = ""}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.zone2variable = {}
buildervar.zone2variable.Id ="76330b4c-1da2-4701-b6d7-d3bc579575b4"
buildervar.zone2variable.Name = "zone 2 variable"
buildervar.zone2variable.Type = "Number"
buildervar.zone2variable.Data=[[0]]
buildervar.zone2variable.Description=[[]]

buildervar.zone1variable = {}
buildervar.zone1variable.Id ="950f9a27-5971-454a-a867-df27634ac84a"
buildervar.zone1variable.Name = "zone 1 variable"
buildervar.zone1variable.Type = "Number"
buildervar.zone1variable.Data=[[0]]
buildervar.zone1variable.Description=[[]]

buildervar.zone3variable = {}
buildervar.zone3variable.Id ="41a4c0c6-1525-4eaf-b160-f586db852015"
buildervar.zone3variable.Name = "zone 3 variable"
buildervar.zone3variable.Type = "Number"
buildervar.zone3variable.Data=[[0]]
buildervar.zone3variable.Description=[[]]

buildervar.zone4variable = {}
buildervar.zone4variable.Id ="efb29ab9-086d-4eee-a5e1-22b26fd0fb40"
buildervar.zone4variable.Name = "zone 4 variable"
buildervar.zone4variable.Type = "String"
buildervar.zone4variable.Data=[[]]
buildervar.zone4variable.Description=[[]]

buildervar.finalvariable = {}
buildervar.finalvariable.Id ="9fc16739-0cbf-49ba-ac10-1b6557065551"
buildervar.finalvariable.Name = "final variable"
buildervar.finalvariable.Type = "String"
buildervar.finalvariable.Data=[[]]
buildervar.finalvariable.Description=[[]]


-- ZTimers --

-- Inputs --
zinputzone1input = Wherigo.ZInput(cartWherigoKinzuaEagles)
zinputzone1input.Id="c018ef97-a9c7-4bc9-847f-86d29f8a7e84"
zinputzone1input.Name="zone 1 input"
zinputzone1input.Description=[[]]
zinputzone1input.Visible=true
zinputzone1input.InputType="Text"
zinputzone1input.InputVariableId="950f9a27-5971-454a-a867-df27634ac84a"
zinputzone1input.Text=[[The source of the Allegheny river is how many  miles upstram of the Kinzua dam?]]

zinputzone3input = Wherigo.ZInput(cartWherigoKinzuaEagles)
zinputzone3input.Id="37780e97-4b31-487f-8ef5-9c8ee077f33d"
zinputzone3input.Name="zone 3 input"
zinputzone3input.Description=[[]]
zinputzone3input.Visible=true
zinputzone3input.InputType="Text"
zinputzone3input.InputVariableId="41a4c0c6-1525-4eaf-b160-f586db852015"
zinputzone3input.Text=[[How many different species of birds are pictured on the informational sign?]]

zinputzone2input = Wherigo.ZInput(cartWherigoKinzuaEagles)
zinputzone2input.Id="6f8f602b-141d-4cce-a475-14851d337db2"
zinputzone2input.Name="zone 2 input"
zinputzone2input.Description=[[]]
zinputzone2input.Visible=true
zinputzone2input.InputType="Text"
zinputzone2input.InputVariableId="76330b4c-1da2-4701-b6d7-d3bc579575b4"
zinputzone2input.Text=[[How many sources of NONPOINT Source Pollution are shown putting pollution in the river in the diagram on the informational sign?]]

zinputzone4input = Wherigo.ZInput(cartWherigoKinzuaEagles)
zinputzone4input.Id="ebc511cb-189e-4657-978d-32db92e9909a"
zinputzone4input.Name="zone 4 input"
zinputzone4input.Description=[[]]
zinputzone4input.Visible=true
zinputzone4input.InputType="Text"
zinputzone4input.InputVariableId="efb29ab9-086d-4eee-a5e1-22b26fd0fb40"
zinputzone4input.Text=[[How many years pass before a bald eagle will obtain the completely white head and tail of the mature eagle? example answer- 5 to 9]]

zinputfinalinput = Wherigo.ZInput(cartWherigoKinzuaEagles)
zinputfinalinput.Id="7ded1989-3ee7-456b-aa36-fcf2f99917c0"
zinputfinalinput.Name="final input"
zinputfinalinput.Description=[[]]
zinputfinalinput.Visible=true
zinputfinalinput.InputType="Text"
zinputfinalinput.InputVariableId="9fc16739-0cbf-49ba-ac10-1b6557065551"
zinputfinalinput.Text=[[What is the code word from the cache?]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function cartWherigoKinzuaEagles:OnStart()
-- #GroupDescription=Cart Start --
-- #Comment=Cart Start Comment --
cartWherigoKinzuaEagles.Complete = false
Wherigo.MessageBox{Text=[[Welcome to the Wherigo Kinzua Eagles cartridge. You will be taking a tour and stopping at three informational signs. At each sign you will need to correctly answer a question before being allowed to continue on. At one point along the tour, you will be asked a very specific question about bald eagles, so pay close attention to any information on them! At the cache site, you will need to give the tourguide a code from the inside of the cache to mark the cartridge as complete. Head on over to the first zone and talk to the tourguide for your first question.]],Callback=cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB1}
end

function zoneZone1:OnProximity()
-- #GroupDescription=zone1prox --
-- #Comment=zone1prox Comment --
Wherigo.MessageBox{Text=[[Talk to the tourguide]],}
zcharacterTourguide.Visible = true
zcharacterTourguide.Commands["Getfirstquestion"].Enabled = true
end

function zcharacterTourguide:OnGetfirstquestion()
-- #GroupDescription=first answer --
-- #Comment=first answer Comment --
Wherigo.GetInput(zinputzone1input)
end

function zinputzone1input:OnGetInput(input)
zone1variable = tonumber(input)
-- #GroupDescription=answer first --
-- #Comment=answer first Comment --
if   zone1variable == 130 then
Wherigo.MessageBox{Text=[[That's right! The Allegheny river's source is on Cobb Hill in central Potter County PA about 10 miles south of the NY PA border. It joins the Mononghela River in Pittsburgh to form the Ohio river. The water that flows past here will eventually reach the Gulf of Mexico via the Ohio and Mississippi Rivers. Now head over to zone 2 and talk to your tourguide again for your next question.]],Media=zmediaeagle,Callback=cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB2}
else
if   zone1variable ~= 130 then
Wherigo.MessageBox{Text=[[I'm sorry, but that's not the right answer. Check the signs and talk to your tourguide again.]],Media=zmediaeagle,}
end
end
end

function zoneZone2:OnProximity()
-- #GroupDescription=zone2prox --
-- #Comment=zone2prox Comment --
zcharacterTourguide.Commands["Getfirstquestion"].Enabled = false
zcharacterTourguide:MoveTo(zoneZone2)
zcharacterTourguide.Commands["Getsecondquestion"].Enabled = true
zcharacterTourguide.Visible = true
Wherigo.MessageBox{Text=[[Go talk to the tourguide.]],}
zoneZone1.Visible = false
zoneZone1.Active = false
end

function zcharacterTourguide:OnGetsecondquestion()
-- #GroupDescription=second answer --
-- #Comment=second answer Comment --
Wherigo.GetInput(zinputzone2input)
end

function zinputzone2input:OnGetInput(input)
zone2variable = tonumber(input)
-- #GroupDescription=answer2nd --
-- #Comment=answer2nd Comment --
if   zone2variable == 6 then
Wherigo.MessageBox{Text=[[Thats right. Environmental pollution, especially the pesticide DDT was a major reason for the decline of the bald eagle population. Thankfully, since DDT was banned, the bald eagle population has rebounded and is no longer considered an endangered or threatened species. Now continue on to the third zone for another question from your tourguide.]],Media=zmediaeagle,Callback=cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB3}
else
if   zone2variable ~= 6 then
Wherigo.MessageBox{Text=[[That's not quite the answer I was looking for. Better read the sign and talk to me again when you are done.]],Media=zmediazookeeper,}
end
end
end

function zoneZone3:OnProximity()
-- #GroupDescription=zone3prox --
-- #Comment=zone3prox Comment --
zcharacterTourguide.Commands["Getsecondquestion"].Enabled = false
zcharacterTourguide.Commands["Getthirdquestion"].Enabled = true
zcharacterTourguide:MoveTo(zoneZone3)
Wherigo.MessageBox{Text=[[OK, time for another question from your tourguide.]],}
zcharacterTourguide.Visible = true
zoneZone2.Visible = false
zoneZone2.Active = false
end

function zcharacterTourguide:OnGetthirdquestion()
-- #GroupDescription=thirdanswer --
-- #Comment=thirdanswer Comment --
Wherigo.GetInput(zinputzone3input)
end

function zinputzone3input:OnGetInput(input)
zone3variable = tonumber(input)
-- #GroupDescription=answerthird --
-- #Comment=answerthird Comment --
if   zone3variable == 5 then
Wherigo.MessageBox{Text=[[That's right. This area is home to many species of birds and animals in addition to the ones on the sign. Now follow your GPS to teh fourth zone where I'll ask the last question before you can find the cache.]],Media=zmediazookeeper,Callback=cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB4}
zcharacterTourguide:MoveTo(zoneZone4)
zcharacterTourguide.Visible = false
elseif zone3variable ~= 5 then
Wherigo.MessageBox{Text=[[No, that's not quite right, better check the sign then talk to me again.]],Media=zmediazookeeper,}
end
end

function zoneZone4:OnProximity()
-- #GroupDescription=zone4prox --
-- #Comment=zone4prox Comment --
zoneZone3.Visible = false
zcharacterTourguide:MoveTo(zoneZone4)
zcharacterTourguide.Commands["Getthirdquestion"].Enabled = false
zcharacterTourguide.Commands["Getfourthquestion"].Enabled = true
zcharacterTourguide.Visible = true
Wherigo.MessageBox{Text=[[Talk to the tourguide for your final question before the location of the cache is revealed.]],}
end

function zcharacterTourguide:OnGetfourthquestion()
-- #GroupDescription=fourthtalk --
-- #Comment=fourthtalk Comment --
Wherigo.GetInput(zinputzone4input)
end

function zinputzone4input:OnGetInput(input)
zone4variable = input
-- #GroupDescription=zone4answer --
-- #Comment=zone4answer Comment --
if   Wherigo.NoCaseEquals(zone4variable,"4 to 5") then
Wherigo.MessageBox{Text=[[That's right, the bald eagle takes 4 to 5 years to become mature. The average lfespan in the wild is about 20 years, in captivity at least one bald eagle lived to be 50 years old. Now it's time to go find the cache! Remember, after you find the cache there will be a code word inside the logbook or lid of the cache, you MUST talk to th etourguide one last time and give him that word to complete the cartridge. GOOD LUCK!]],Media=zmediaeagle,Callback=cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB5}
elseif not Wherigo.NoCaseEquals(zone4variable,"4 to 5") then
Wherigo.MessageBox{Text=[[Sorry, that's not quite right. I'm looking for a range of years, like 8 to 9 . ]],Media=zmediazookeeper,}
end
end

function zoneFinal:OnProximity()
-- #GroupDescription=finalprox --
-- #Comment=finalprox Comment --
zoneZone4.Visible = false
zoneZone4.Active = false
zcharacterTourguide.Commands["Getfourthquestion"].Enabled = false
zcharacterTourguide.Commands["Givecodewordfromcache"].Enabled = true
zcharacterTourguide.Visible = true
Wherigo.MessageBox{Text=[[Don't forget to give the code word from the cache to the tourguide! The coordinates of  the cache are.N 41 50.525 W 079 01.013.  You should be within 20 feet or so of the cache right now.]],Media=zmediaeagle,}
end

function zcharacterTourguide:OnGivecodewordfromcache()
-- #GroupDescription=finalanswer --
-- #Comment=finalanswer Comment --
Wherigo.GetInput(zinputfinalinput)
end

function zinputfinalinput:OnGetInput(input)
finalvariable = input
-- #GroupDescription=finalanswer --
-- #Comment=finalanswer Comment --
if   Wherigo.NoCaseEquals(finalvariable,"Soaring") then
cartWherigoKinzuaEagles.Complete = true
cartWherigoKinzuaEagles:RequestSync()
Wherigo.MessageBox{Text=[[Congratulations on finding the cache! On behalf of kcepenn and MickEMT I'd like to thank you for playing our wherigo cartridge, everyone involved hopes you had fun and learned something new about the bald eagle. Be sure to either upload your save game file which ends in .gwz or the completion code on the cartridge page at wherigo.com to unlock the cartridge on that site. Also, don't forget to log your find on both sites. Your completion code is:]] ..Player.CompletionCode,Media=zmediazookeeper,}
elseif not Wherigo.NoCaseEquals(finalvariable,"Soaring") then
Wherigo.MessageBox{Text=[[Hmm, somethinmgs not right here, better check the code word again. ]],Media=zmediazookeeper,}
end
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=5#--
cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=first message --
-- #Comment=first message Comment --
zoneZone1.Active = true
zoneZone1.Visible = true
end
end

cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
if action ~= nil then
-- #GroupDescription=zone1correct --
-- #Comment=zone1correct Comment --
zoneZone2.Active = true
zoneZone2.Visible = true
zcharacterTourguide.Visible = false
zcharacterTourguide:MoveTo(zoneZone2)
end
end

cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if action ~= nil then
-- #GroupDescription=secondright --
-- #Comment=secondright Comment --
zcharacterTourguide.Visible = false
zcharacterTourguide.Commands["Getsecondquestion"].Enabled = false
zcharacterTourguide:MoveTo(zoneZone3)
zoneZone3.Active = true
zoneZone3.Visible = true
end
end

cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB4 = function(action)
if action ~= nil then
-- #GroupDescription=thirdright --
-- #Comment=thirdright Comment --
zoneZone4.Active = true
zoneZone4.Visible = true
end
end

cartWherigoKinzuaEagles.MsgBoxCBFuncs.MsgBoxCB5 = function(action)
if action ~= nil then
-- #GroupDescription=fourthright --
-- #Comment=fourthright Comment --
zoneFinal.Active = true
zoneFinal.Visible = true
zcharacterTourguide:MoveTo(zoneFinal)
zcharacterTourguide.Visible = false
zcharacterTourguide.Commands["Getfourthquestion"].Enabled = false
end
end

------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- #End Author Functions# --
-- Nothing after this line --
return cartWherigoKinzuaEagles
